/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.stats;

import com.google.common.collect.Maps;
import doggytalents.common.util.Cache;
import doggytalents.common.util.NBTUtil;
import java.util.Collections;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.registries.ForgeRegistries;

public class StatsTracker {
    private Map<EntityType<?>, Integer> ENTITY_KILLS = Maps.newHashMap();
    private float damageDealt = 0.0f;
    private int distanceOnWater = 0;
    private int distanceInWater = 0;
    private int distanceSprinting = 0;
    private int distanceSneaking = 0;
    private int distanceWalking = 0;
    private int distanceRidden = 0;
    private final Cache<Integer> killCount = Cache.make(this::getTotalKillCountInternal);

    public void writeAdditional(CompoundTag compound) {
        ListTag killList = new ListTag();
        for (Map.Entry<EntityType<?>, Integer> entry : this.ENTITY_KILLS.entrySet()) {
            CompoundTag stats = new CompoundTag();
            NBTUtil.putRegistryValue(stats, "type", ForgeRegistries.ENTITY_TYPES.getKey(entry.getKey()));
            stats.m_128405_("count", entry.getValue().intValue());
            killList.add((Object)stats);
        }
        compound.m_128365_("entityKills", (Tag)killList);
        compound.m_128347_("damageDealt", (double)this.damageDealt);
        compound.m_128405_("distanceOnWater", this.distanceOnWater);
        compound.m_128405_("distanceInWater", this.distanceInWater);
        compound.m_128405_("distanceSprinting", this.distanceSprinting);
        compound.m_128405_("distanceSneaking", this.distanceSneaking);
        compound.m_128405_("distanceWalking", this.distanceWalking);
        compound.m_128405_("distanceRidden", this.distanceRidden);
    }

    public void readAdditional(CompoundTag compound) {
        ListTag killList = compound.m_128437_("entityKills", 10);
        for (int i = 0; i < killList.size(); ++i) {
            CompoundTag stats = killList.m_128728_(i);
            EntityType type = (EntityType)NBTUtil.getRegistryValue(stats, "type", ForgeRegistries.ENTITY_TYPES);
            this.ENTITY_KILLS.put(type, stats.m_128451_("count"));
        }
        this.damageDealt = compound.m_128457_("damageDealt");
        this.distanceOnWater = compound.m_128451_("distanceOnWater");
        this.distanceInWater = compound.m_128451_("distanceInWater");
        this.distanceSprinting = compound.m_128451_("distanceSprinting");
        this.distanceSneaking = compound.m_128451_("distanceSneaking");
        this.distanceWalking = compound.m_128451_("distanceWalking");
        this.distanceRidden = compound.m_128451_("distanceRidden");
    }

    public int getKillCountFor(EntityType<?> type) {
        return this.ENTITY_KILLS.getOrDefault(type, 0);
    }

    public int getKillCountFor(Predicate<MobCategory> classification) {
        int total = 0;
        for (Map.Entry<EntityType<?>, Integer> entry : this.ENTITY_KILLS.entrySet()) {
            if (!classification.test(entry.getKey().m_20674_())) continue;
            total += entry.getValue().intValue();
        }
        return total;
    }

    private int getTotalKillCountInternal() {
        int total = 0;
        for (Map.Entry<EntityType<?>, Integer> entry : this.ENTITY_KILLS.entrySet()) {
            total += entry.getValue().intValue();
        }
        return total;
    }

    public Map<EntityType<?>, Integer> getAllKillCount() {
        return Collections.unmodifiableMap(this.ENTITY_KILLS);
    }

    public int getTotalKillCount() {
        return this.killCount.get();
    }

    public void incrementKillCount(Entity entity) {
        this.incrementKillCount(entity.m_6095_());
    }

    private void incrementKillCount(EntityType<?> type) {
        this.ENTITY_KILLS.compute(type, (k, v) -> (v == null ? 0 : v) + 1);
    }

    public void increaseDamageDealt(float damage) {
        this.damageDealt += damage;
    }

    public void increaseDistanceOnWater(int distance) {
        this.distanceOnWater += distance;
    }

    public void increaseDistanceInWater(int distance) {
        this.distanceInWater += distance;
    }

    public void increaseDistanceSprint(int distance) {
        this.distanceSprinting += distance;
    }

    public void increaseDistanceSneaking(int distance) {
        this.distanceSneaking += distance;
    }

    public void increaseDistanceWalk(int distance) {
        this.distanceWalking += distance;
    }

    public void increaseDistanceRidden(int distance) {
        this.distanceRidden += distance;
    }

    public float getDamageDealt() {
        return this.damageDealt;
    }

    public int getDistanceOnWater() {
        return this.distanceOnWater;
    }

    public int getDistanceInWater() {
        return this.distanceInWater;
    }

    public int getDistanceSprint() {
        return this.distanceSprinting;
    }

    public int getDistanceSneaking() {
        return this.distanceSneaking;
    }

    public int getDistanceWalk() {
        return this.distanceWalking;
    }

    public int getDistanceRidden() {
        return this.distanceRidden;
    }

    public void clearAllStatsKill() {
        this.ENTITY_KILLS.clear();
    }

    public void serializeToBuf(FriendlyByteBuf buf) {
        buf.writeFloat(this.damageDealt);
        buf.writeInt(this.distanceOnWater);
        buf.writeInt(this.distanceInWater);
        buf.writeInt(this.distanceSprinting);
        buf.writeInt(this.distanceSneaking);
        buf.writeInt(this.distanceWalking);
        buf.writeInt(this.distanceRidden);
        int mapSize = this.ENTITY_KILLS.size();
        buf.writeInt(mapSize);
        for (Map.Entry<EntityType<?>, Integer> entry : this.ENTITY_KILLS.entrySet()) {
            ResourceLocation typeId = ForgeRegistries.ENTITY_TYPES.getKey(entry.getKey());
            Integer killCount = entry.getValue();
            buf.m_130085_(typeId);
            buf.writeInt(killCount.intValue());
        }
    }

    public void deserializeFromBuf(FriendlyByteBuf buf) {
        this.damageDealt = buf.readFloat();
        this.distanceOnWater = buf.readInt();
        this.distanceInWater = buf.readInt();
        this.distanceSprinting = buf.readInt();
        this.distanceSneaking = buf.readInt();
        this.distanceWalking = buf.readInt();
        this.distanceRidden = buf.readInt();
        this.ENTITY_KILLS.clear();
        int mapSize = buf.readInt();
        for (int i = 0; i < mapSize; ++i) {
            ResourceLocation typeId = buf.m_130281_();
            int killCount = buf.readInt();
            EntityType type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(typeId);
            this.ENTITY_KILLS.put(type, killCount);
        }
    }

    public void shallowCopyFrom(StatsTracker stats) {
        this.ENTITY_KILLS = stats.ENTITY_KILLS;
        this.damageDealt = stats.damageDealt;
        this.distanceOnWater = stats.distanceOnWater;
        this.distanceInWater = stats.distanceInWater;
        this.distanceSprinting = stats.distanceSprinting;
        this.distanceSneaking = stats.distanceSneaking;
        this.distanceWalking = stats.distanceWalking;
        this.distanceRidden = stats.distanceRidden;
    }
}

